<?php

namespace App\Http\Controllers\Inventory;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;
use App\Models\FactoryOrder;
use App\Models\FactoryCart;
use App\Models\InventoryProduct;

class FactoryOrdersController extends Controller
{
    public function index(Request $request)
    {
        // 获取查询参数
        $searchQuery = $request->input('q', '');
        $searchColumn = $request->input('column', 'all');
        $page = $request->input('page', 1);
        $itemsPerPage = $request->input('itemsPerPage', 10);
        $sortBy = $request->input('sortBy', 'created_at');
        $orderBy = $request->input('orderBy', 'desc');

        $user = $request->user();

        // 查询订单数据
        $query = FactoryOrder::query()->where('company_id', $user->company_id);

        // 如果有搜索查询，则按条件过滤
        if ($searchQuery) {
            $query->where(function($q) use ($searchQuery, $searchColumn) {
                if ($searchColumn === 'all') {
                    $q->where('user_email', 'like', '%' . $searchQuery . '%')
                      ->orWhere('factory_orders.id', $searchQuery)
                      ->orWhere('factory_orders.user_job_id', 'like', '%' . $searchQuery . '%')
                      ->orWhere('status', 'like', '%' . $searchQuery . '%')
                      ->orWhere('created_at', 'like', '%' . $searchQuery . '%')
                      ->orWhere('total', $searchQuery);
                } else {
                    if (in_array($searchColumn, ['id', 'total'])) {
                        $q->where('factory_orders.' . $searchColumn, $searchQuery);
                    } else {
                        $q->where('factory_orders.' . $searchColumn, 'like', '%' . $searchQuery . '%');
                    }
                }
            });
        }

        // 进行排序
        $query->orderBy($sortBy, $orderBy);

        // 获取分页数据
        $orders = $query->paginate($itemsPerPage, ['*'], 'page', $page);

        $orderCounts = FactoryOrder::select('status', \DB::raw('count(*) as total'))->where('company_id', $user->company_id)->groupBy('status')->get();

        $orderStatuses = [];

        foreach ($orderCounts as $orderCount) {
            $orderStatuses[$orderCount['status']] = $orderCount['total'];
        }

        // 返回响应数据
        return response()->json([
            'orders' => $orders->items(),
            'total' => $orders->total(),
            'current_page' => $orders->currentPage(),
            'per_page' => $orders->perPage(),
            'orderStatuses' => $orderStatuses
        ]);
    }
}
