<?php

namespace App\Http\Controllers\Product;

use App\Http\Controllers\Controller;
use App\Models\MainProduct;
use App\Models\Discount;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class MainProductController extends Controller
{
    /**
     * 获取所有状态为 active 的主产品及其关联的产品
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function getMainProductsWithProducts()
    {
        $user = Auth::user();

        if($user->group_id > 9) {
            $mainProducts = MainProduct::where('status', 'active')
                ->with(['products' => function($query) {
                    // 可选：仅获取状态为 active 的产品
                    $query->where('status', '!=', 'Disabled')->orderBy('sort_order')->orderBy('width')->orderBy('height');
                }])
                ->orderBy('sort_order')
                ->get();
        } else {
            $mainProducts = [];
        }
            
        foreach ($mainProducts as $key => $mainProduct) {
            $users = DB::table('main_product_to_users')->where('main_product_id', $mainProduct->id)->get()->pluck('user_id')->toArray();
            if(count($users) && !in_array($user->id, $users)) {
               unset($mainProducts[$key]);
               continue;
            }

            $mainProducts[$key]['exist_discount'] = 0;
            if(in_array('agent_purchase', $user->permissions)) {
                foreach ($mainProduct->products as $productKey => $product) {
                    $discounts = Discount::Select('discount_price', 'min_quantity')->where('product_id', $product->id)->get();
                    $mainProducts[$key]['products'][$productKey]['discounts'] = $discounts;

                    if(count($discounts)) {
                        $mainProducts[$key]['exist_discount'] += 1;
                    }
                }
            }
        }

        return response()->json([
            'success' => true,
            'data' => $mainProducts->values(),
        ]);
    }
    /**
     * 获取单个主产品详情及其关联的产品
     *
     * @param int $id
     * @return \Illuminate\Http\JsonResponse
     */
    public function getMianProductDetail($id)
    {
        $user = Auth::user();

        if ($user->group_id <= 9) {
            return response()->json([
                'success' => false,
                'message' => 'Access denied',
            ], 403);
        }

        $mainProduct = MainProduct::where('id', $id)
            ->where('status', 'active')
            ->with(['products' => function ($query) {
                $query->where('status', '!=', 'Disabled')->orderBy('sort_order')->orderBy('width')->orderBy('height');
            }])
            ->first();

        if (!$mainProduct) {
            return response()->json([
                'success' => false,
                'message' => 'Product not found',
            ], 404);
        }

        // 检查用户权限
        $users = DB::table('main_product_to_users')->where('main_product_id', $mainProduct->id)->get()->pluck('user_id')->toArray();
        if (count($users) && !in_array($user->id, $users)) {
            return response()->json([
                'success' => false,
                'message' => 'Access denied',
            ], 403);
        }

        $mainProduct['exist_discount'] = 0;
        if (in_array('agent_purchase', $user->permissions)) {
            foreach ($mainProduct->products as $productKey => $product) {
                $discounts = Discount::Select('discount_price', 'min_quantity')->where('product_id', $product->id)->get();
                $mainProduct['products'][$productKey]['discounts'] = $discounts;

                if (count($discounts)) {
                    $mainProduct['exist_discount'] += 1;
                }
            }
        }

        return response()->json([
            'success' => true,
            'data' => $mainProduct,
        ]);
    }
}
