<?php

namespace App\Http\Controllers\Tool;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;

class UploadController extends Controller
{
    public function upload(Request $request)
    {
        $request->validate([
            'file' => 'required|mimes:jpeg,png,jpg,pdf|max:204800',
            'storage_folder' => 'required|string'
        ]);

        try {
            // 生成唯一文件名
            $fileName = Str::uuid() . '.' . $request->file('file')->getClientOriginalExtension();
            
            // 存储图片
            $path = $request->file('file')->storeAs($request->storage_folder, $fileName, 'public');

            return response()->json([
                'success' => true,
                'file_url' => Storage::url($path),
            ]);
            
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Upload failed: ' . $e->getMessage()
            ], 500);
        }
    }
}