<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class CompanyAdminRoute
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        $user = Auth::user();

        // 检查用户状态是否为 "Active"
        if ($user && $user->group_id < 10 ) {
            Auth::logout();
            return redirect()->route('login')->withErrors([
                'status' => __('Your account does not have permission to access this page.'),
            ]);
        }

        return $next($request);
    }
}