<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Model;
use DateTimeInterface;

class FactoryOrder extends Model
{
    // 可填充的字段
    protected $fillable = [
        'print_job_id',
        'user_id',
        'user_email',
        'company_id',
        'user_job_id',
        'total',
        'quantity',
        'use_balance',
        'total_shipping_fee',
        'shipping_label',
        'shipping_labels',
        'comments',
        'status',
    ];

    protected $casts = [
        'shipping_labels' => 'array'
    ];

    /**
     * 获取订单关联的图片
     */
    public function cartImages(): HasMany
    {
        return $this->hasMany(CartImage::class, 'factory_order_id', 'id');
    }

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }
}