<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use DateTimeInterface;
use App\Models\MainProduct;
use DB;

class InventoryProduct extends Model
{
    use HasFactory;

    /**
     * 可以批量赋值的属性
     *
     * @var array
     */
    protected $fillable = [
        'order_id',
        'user_id',
        'company_id',
        'main_product_id',
        'main_product_name',
        'product_id',
        'product_name',
        'product_image',
        'quantity',
        'width',
        'height',
        'price',
        'type',
        'option',
        'inventory_type',
        'job_id',
        'comments'
    ];

    /**
     * 属性类型转换
     *
     * @var array
     */
    protected $casts = [

    ];

    /**
     * 访问器：获取完整的图片 URL
     *
     * @return string
     */
    public function getImageUrlAttribute()
    {
        return $this->image ? asset('storage/' . $this->image) : null;
    }

    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('y-m-d H:i');
    }

    public static function findInventoryProductsTotal($data, $companyId = null)
    {
        if(!$companyId) {
            $companyId = Auth::user()->company_id;
        }

        return self::lockForUpdate()
            ->where('company_id', $companyId)
            ->where('product_id', $data['product_id'])
            ->where('width', $data['width'])
            ->where('height', $data['height'])
            ->sum('quantity');
    }

    public static function getInventoryProducts($data)
    {
        $user = Auth::user();

        return self::select('product_id as id', 
                'product_name as name', 
                'width',
                'height',
                'type',
                'price',
                '`option`',
                'quantity'
            )
            ->where('company_id', $user->company_id)
            ->where('product_id', $data['product_id'])
            ->where('width', $data['width'])
            ->where('height', $data['height'])
            ->get();
    }

    public static function getGroupedData($mainProductId)
    {
        $user = Auth::user();

        return self::select(
                'product_id as id',
                 DB::raw('ANY_VALUE(product_name) as name'), 
                'width',
                'height',
                'type',
                DB::raw('ANY_VALUE(price) as price'), 
                DB::raw('ANY_VALUE(`option`) as `option`'), 
                DB::raw('SUM(quantity) as quantity')
            )
            ->where('main_product_id', $mainProductId)
            ->where('company_id', $user->company_id)
            ->groupBy(
                'product_id',
                'width',
                'height',
                'type',
            )
            //->having('quantity', '>=', 0)
            ->get();
    }
}
