<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Model;
use DateTimeInterface;

class Order extends Model
{
    // 可填充的字段
    protected $fillable = [
        'user_id',
        'user_email',
        'company_id',
        'use_balance',
        'total',
        'use_balance',
        'payment_method',
        'payment_information',
        'bank_transfer_receipt',
        'status',
    ];

    public function inventoryProduct(): HasMany
    {
        return $this->hasMany(InventoryProduct::class, 'order_id', 'id');
    }

    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }
}