<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Product\MainProductController;
use App\Http\Controllers\Checkout\CartController;
use App\Http\Controllers\Checkout\ConfirmController;
use App\Http\Controllers\Order\OrdersController;
use App\Http\Controllers\Inventory\InventoryProductController;
use App\Http\Controllers\Account\UserController;
use App\Http\Controllers\Account\PasswordChangeController;
use App\Http\Controllers\Account\UserProfileController;
use App\Http\Controllers\Inventory\FactoryCartController;
use App\Http\Controllers\Inventory\ImageUploadController;
use App\Http\Controllers\Inventory\FactoryOrderController;
use App\Http\Controllers\Inventory\FactoryOrdersController;
use App\Http\Controllers\Inventory\ShipmentTrackingController;
use App\Http\Controllers\Tool\UploadController;
use App\Http\Controllers\Gallery\GalleryController;
use App\Http\Controllers\Gallery\FolderController;
use App\Http\Controllers\Language\LocaleController;

use App\Http\Controllers\Admin\User\UsersController;
use App\Http\Controllers\Admin\Product\ProductsController;
use App\Http\Controllers\Admin\Product\MainProductsController;
use App\Http\Controllers\Admin\Company\CompaniesController;
use App\Http\Controllers\Admin\Order\CompanyOrdersController;
use App\Http\Controllers\Admin\Purchase\PurchaseOrdersController;
use App\Http\Controllers\Admin\User\ImpersonateController;
use App\Http\Controllers\Admin\Report\FactoryOrderReportController;
use App\Http\Controllers\Admin\Product\DiscountsController;
use App\Http\Controllers\Admin\Product\BoxesController;

Route::middleware(['auth:sanctum'])->get('/user', function (Request $request) {
    return $request->user();
});

Route::prefix('admin')->middleware(['auth', 'check.status', 'admin.route', 'session.expired'])->group(function () {

    Route::get('/users', [UsersController::class, 'index']);
    Route::delete('/delete-users/{user}', [UsersController::class, 'deleteUser']);

    Route::get('/get-user/{id}', [UsersController::class, 'getUser']);
    Route::put('/update-user/{id}', [UsersController::class, 'updateUser']);
    Route::put('/update-user-balance/{id}', [UsersController::class, 'updateUserBalance']);
    Route::get('/get-users', [UsersController::class, 'getUsers']);

    Route::get('/products', [ProductsController::class, 'index']);
    Route::get('/main-products', [ProductsController::class, 'getMainProducts']);
    Route::get('/get-product/{id}', [ProductsController::class, 'getProduct']);
    Route::put('/update-product/{id}', [ProductsController::class, 'updateProduct']);
    Route::post('/add-product', [ProductsController::class, 'addProduct']);
    Route::delete('/delete-product/{id}', [ProductsController::class, 'deleteProduct']);

    Route::get('/companies', [CompaniesController::class, 'index']);
    Route::get('/get-company/{id}', [CompaniesController::class, 'getCompany']);
    Route::put('/update-company/{id}', [CompaniesController::class, 'updateCompany']);
    Route::post('/add-company', [CompaniesController::class, 'addCompany']);
    Route::delete('/delete-company/{id}', [CompaniesController::class, 'deleteCompany']);

    Route::get('/factory-orders', [CompanyOrdersController::class, 'index']);
    Route::get('/get-factory-order/{id}', [CompanyOrdersController::class, 'getFactoryOrderDetails']);

    Route::get('/purchase-orders', [PurchaseOrdersController::class, 'index']);
    Route::get('/get-purchase-order/{id}', [PurchaseOrdersController::class, 'getOrderDetails']);
    Route::post('/add-purchase-order', [PurchaseOrdersController::class, 'addPurchaseOrder']);

    Route::get('/users/{user}/impersonate', [ImpersonateController::class, 'impersonate'])->name('users.impersonate');
    Route::get('/impersonate/leave', [ImpersonateController::class, 'leaveImpersonate'])->name('impersonate.leave');

    Route::get('factory-order-report/statistics', [FactoryOrderReportController::class, 'getStatistics']);

    Route::get('/discounts', [DiscountsController::class, 'index']);
    Route::get('/get-discount/{id}', [DiscountsController::class, 'getDiscount']);
    Route::post('/add-discount', [DiscountsController::class, 'addDiscount']);
    Route::put('/update-discount/{id}', [DiscountsController::class, 'updateDiscount']);
    Route::delete('/delete-discount/{id}', [DiscountsController::class, 'deleteDiscount']);

    Route::get('/boxes', [BoxesController::class, 'index']);
    Route::get('/boxes/{id}', [BoxesController::class, 'show']);
    Route::post('/boxes', [BoxesController::class, 'store']);
    Route::put('/boxes/{id}', [BoxesController::class, 'update']);
    Route::delete('/boxes/{id}', [BoxesController::class, 'destroy']);
    Route::get('/all-boxes', [BoxesController::class, 'allBoxes']);
    Route::get('/product-to-boxes/{id}', [BoxesController::class, 'productToBoxes']);

    Route::get('/all-main-products', [MainProductsController::class, 'index']);
    Route::post('/add-main-product', [MainProductsController::class, 'store']);
    Route::post('/update-main-product/{id}', [MainProductsController::class, 'update']);
    Route::delete('/delete-main-product/{id}', [MainProductsController::class, 'destroy']);
    Route::get('/get-main-product/{id}', [MainProductsController::class, 'show']);

    Route::get('/product-users/{id}', [ProductsController::class, 'productUsers']);
    Route::get('/main-product-users/{id}', [MainProductsController::class, 'mainProductUsers']);
});


Route::middleware(['auth', 'check.status', 'session.expired'])->group(function () {
    Route::get('/', function() {
        return view('application');
    })->where('any', '.*');

    Route::get('/order/{any?}', function() {
        return view('application');
    })->where('any', '.*');

    Route::get('/product/{any?}', function() {
        return view('application');
    })->where('any', '.*');

    Route::get('/inventory/{any?}', function() {
        return view('application');
    })->where('any', '.*');

    Route::get('/account/{any?}', function() {
        return view('application');
    })->where('any', '.*');

    Route::middleware(['companyAdmin.route'])->group(function () {
        Route::get('/main-products', [MainProductController::class, 'getMainProductsWithProducts']);
        Route::post('/add-to-cart', [CartController::class, 'addToCart']);   
        Route::delete('/remove-from-cart/{cart_id}', [CartController::class, 'removeFromCart']);
        Route::put('/update-cart/{cart_id}', [CartController::class, 'updateCartItem']);
        Route::post('/add-order', [ConfirmController::class, 'addOrder']);
        Route::post('/upload-receipt', [ConfirmController::class, 'upload']);
        Route::get('/orders', [OrdersController::class, 'index']);
        Route::get('/get-order/{id}', [OrdersController::class, 'getOrderDetails']);
        Route::put('/cancel-order/{id}', [OrdersController::class, 'cancelOrder']);
    });
    
    Route::get('/main-products-detail/{id}', [MainProductController::class, 'getMianProductDetail']);

    Route::get('/get-cart-list', [CartController::class, 'getCartList']);
    Route::get('/inventory-products', [InventoryProductController::class, 'getInventoryProducts']);
    Route::get('/user-profile', [UserController::class, 'getCurrentUser']);
    Route::post('/send-to-print', [FactoryCartController::class, 'sendToPrint']);
    Route::get('/get-factory-cart-list', [FactoryCartController::class, 'getFactoryCartList']);
    Route::delete('/remove-from-factory-cart/{cart_id}', [FactoryCartController::class, 'removeFromFactoryCart']);
    Route::put('/update-factory-cart/{cart_id}', [FactoryCartController::class, 'updateFactoryCartItem']);
    Route::get('/get-user-balance', [CartController::class, 'getUserBalance']);
    Route::post('/upload-image', [ImageUploadController::class, 'upload']);
    Route::delete('/delete-image/{id}', [ImageUploadController::class, 'delete']);
    Route::put('/update-factory-cart-image/{cart_image_id}', [FactoryCartController::class, 'updateFactoryCartImage']);
    Route::post('/add-factory-order', [FactoryOrderController::class, 'addFactoryOrder']);
    Route::get('/get-factory-order/{id}', [FactoryOrderController::class, 'getFactoryOrderDetails']);
    Route::put('/cancel-factory-order/{id}', [FactoryOrderController::class, 'cancelFactoryOrder']);
    Route::get('/factory-orders', [FactoryOrdersController::class, 'index']);
    Route::post('/upload-file', [UploadController::class, 'upload']);
    Route::post('/upload-shipping-label', [FactoryCartController::class, 'uploadShippingLabel']);
    Route::post('/remove-shipping-label', [FactoryCartController::class, 'removeShippingLabel']);

    Route::get('/gallery/files', [GalleryController::class, 'getFiles']);
    Route::post('/gallery/upload', [GalleryController::class, 'upload']);
    Route::post('/gallery/batch-delete', [GalleryController::class, 'batchDelete']);
    Route::post('/gallery/batch-download', [GalleryController::class, 'batchDownload']);
    Route::post('/gallery/rename', [GalleryController::class, 'rename']);

    Route::post('/folder/create', [FolderController::class, 'create']);
    Route::get('/folder/list', [FolderController::class, 'list']);
    Route::delete('/folder/delete', [FolderController::class, 'delete']);
    Route::get('/folder/menu', [FolderController::class, 'getMenuStructure']);

    Route::post('/add-from-gallery', [ImageUploadController::class, 'addFromGallery']);

    Route::get('/shipments/{orderId}', [ShipmentTrackingController::class, 'getShippingDetails']);
    Route::post('/shipments/refresh-tracking', [ShipmentTrackingController::class, 'refreshTracking']);

    Route::post('/duplicate-factory-cart', [FactoryCartController::class, 'duplicateFactoryCart']);

    Route::put('/user/password', [PasswordChangeController::class, 'update']);
    Route::get('/get-user-profile', [UserProfileController::class, 'getProfile']);
    Route::post('/update-user-profile', [UserProfileController::class, 'updateProfile']);

    Route::post('/filter-inventory-product', [InventoryProductController::class, 'filterInventoryProduct']);

    Route::post('/update-factory-cart-comments', [FactoryCartController::class, 'updateFactoryCartComments']);
    Route::post('/update-factory-cart-job-id', [FactoryCartController::class, 'updateFactoryCartJobId']);

    Route::get('/get-company-balance', [FactoryCartController::class, 'getCompanyBalance']);

    Route::put('/rotate-factory-cart-image/{cart_image_id}', [FactoryCartController::class, 'rotateFactoryCartImage']);

    Route::post('/upload-barcode/{type}', [FactoryCartController::class, 'uploadBarcode']);
    Route::post('/remove-barcode', [FactoryCartController::class, 'removeBarcode']);
    
    Route::post('/add-new-item', [FactoryCartController::class, 'addNewItem']);
    Route::post('/check-factory-cart-quantity', [FactoryCartController::class, 'checkFactoryCartQuantity']);

    Route::post('/locale', [LocaleController::class, 'setLocale']);

    Route::post('/update-shipping-label/{id}', [FactoryOrderController::class, 'updateShippingLabel']);
    Route::post('/update-user-job-id/{id}', [FactoryOrderController::class, 'updateUserJobId']);

    Route::post('/transfer-inventory', [InventoryProductController::class, 'transferInventoryProduct']);
    Route::get('/transfer-inventory-records', [InventoryProductController::class, 'getTransferInventoryRecords']);

    Route::post('/update-shipping-service-code/{id}', [FactoryCartController::class, 'updateFactoryCartServiceCode']);
    Route::post('/remove-shipping-service-code', [FactoryCartController::class, 'removeFactoryCartServiceCode']);
});


Route::post('/shipping-rates/{id}', [FactoryCartController::class, 'getShippingRates']);
Route::post('/get-best-rate/{id}', [FactoryCartController::class, 'getBestRate']);

Route::get('{any?}', function() {
    return view('application');
})->where('any', '.*');

require __DIR__.'/auth.php';

