// resources/js/navigation/vertical/index.js
import { computed } from 'vue'
import { i18nInstance } from '@/plugins/i18n'
import { useUserStore } from '@/utils/useUserStore'

const useNavItems = () => {
  const t = i18nInstance.global.t
  const userStore = useUserStore()
  
  return computed(() => {
    const companyManagerItems = [
      ...(userStore.user?.permissions?.includes('agent_purchase') ? [
        {
          title: t('navigation.discount-product'),
          to: { name: 'product-discount' },
          icon: { icon: 'tabler-rosette-discount' },
        },
      ] : []),
      {
        title: t('navigation.purchase-product'),
        to: { name: 'product-list' },
        icon: { icon: 'bi--images' },
      },
      {
        title: t('navigation.purchase-history'),
        to: { name: 'order-list' },
        icon: { icon: 'tabler-moneybag' },
      },
      {
        title: t('navigation.transfer-out-inventory'),
        to: { name: 'company-transfer-inventory' },
        icon: { icon: 'tabler-transfer-out' },
      },
      {
        title: t('navigation.transfer-records'),
        to: { name: 'company-transfer-records' },
        icon: { icon: 'tabler-transfer' },
      },
    ]

    // 基础菜单项，所有用户都可以看到
    const companyUserItems = [
      {
        title: t('navigation.my-inventory'),
        to: { name: 'inventory-list' },
        icon: { icon: 'tabler-building-warehouse' },
      },
      {
        title: t('navigation.my-print-job'),
        to: { name: 'factory-list' },
        icon: { icon: 'tabler-printer' },
      },
      {
        title: t('navigation.my-gallery'),
        to: { name: 'gallery' },
        icon: { icon: 'tabler-photo-heart' },
      },
      {
        title: t('navigation.quick-print-job'),
        to: { name: 'inventory-send-to-print' },
        icon: { icon: 'tabler-plane-tilt' },
      },
    ]

    // 管理菜单项，只有 group_id 为 99 的用户可以看到
    const adminMenuItems = [
      {
        title: t('navigation.manage-users'),
        to: { name: 'admin-user-list' },
        icon: { icon: 'tabler-user-check' },
      },
      {
        title: t('navigation.manage-main-products'),
        to: { name: 'admin-main-product-list' },
        icon: { icon: 'tabler-photo-check' },
      },
      {
        title: t('navigation.manage-products'),
        to: { name: 'admin-product-list' },
        icon: { icon: 'tabler-photo-check' },
      },
      {
        title: t('navigation.manage-discount'),
        to: { name: 'admin-discount-list' },
        icon: { icon: 'tabler-rosette-discount' },
      },
      {
        title: t('navigation.manage-companies'),
        to: { name: 'admin-company-list' },
        icon: { icon: 'tabler-buildings' },
      },
      {
        title: t('navigation.manage-factory-orders'),
        to: { name: 'admin-order-list' },
        icon: { icon: 'tabler-coin' },
      },
      {
        title: t('navigation.manage-purchase-orders'),
        to: { name: 'admin-purchase-list' },
        icon: { icon: 'tabler-shopping-cart-cog' },
      },
      {
        title: t('navigation.manage-factory-report'),
        to: { name: 'admin-report-factory' },
        icon: { icon: 'tabler-clipboard-data' },
      },
      {
        title: t('navigation.manage-box'),
        to: { name: 'admin-box-list' },
        icon: { icon: 'tabler-box' },
      },
    ]

    switch (userStore.user?.group_id) {
      case 99:
        return [...companyManagerItems, ...companyUserItems, ...adminMenuItems]
      case 10:
        return [...companyManagerItems, ...companyUserItems]
      default:
        return companyUserItems
    }
  })
}

export default useNavItems
